$(document).ready(function() {
	$('.image-link').magnificPopup({
		type: 'image'
	});
});
var site_url = $('#site_url').val();
var view_name = $('#view_name').val();
// console.log(view_name);
$(document).on('click', '.btn_delete', function() {
	var data = $(this).data('data');
	Swal.fire({
			type: 'warning',
			title: 'แจ้งเตือน',
			text: 'ยืนยันการลบ Username ' + data.user_username,
			confirmButtonText: 'ตกลง',
			confirmButtonColor: '#7cd1f9',
			showCancelButton: true,
			cancelButtonText: 'ยกเลิก',
			reverseButtons: true,
		})
		.then((result) => {
			if (result.value) {
				$.ajax({
					url: site_url + "User/user_delete",
					method: "POST",
					data: {
						user_id: data.user_id,
						user_image: data.user_image
					},
					dataType: 'json',
					success: function(response) {
						$("#div_table").load(site_url + "User/user_load", {
							view_name: view_name
						}, function(responseTxt, statusTxt, xhr) {
							if (statusTxt == "success") {
								const Toast = Swal.mixin({
									toast: true,
									position: 'top-end',
									showConfirmButton: false,
									timer: 2500
								});
								Toast.fire({
									type: 'success',
									title: 'ลบข้อมูลเรียบร้อยแล้ว'
								});
								// Swal.fire({
								// 	type: 'success',
								// 	title: 'แจ้งเตือน',
								// 	text: 'ลบข้อมูลเรียบร้อยแล้ว',
								// 	showConfirmButton: false,
								// 	timer: 900,
								// });
							} else {
								Swal.fire({
									type: 'warning',
									title: 'แจ้งเตือน',
									text: 'การเชื่อมต่อขัดข้อง',
									confirmButtonText: 'ตกลง',
									confirmButtonColor: '#7cd1f9',
								});
							}
						});
					},
					error: function() {
						Swal.fire({
							type: 'warning',
							title: 'แจ้งเตือน',
							text: 'การเชื่อมต่อขัดข้อง',
							confirmButtonText: 'ตกลง',
							confirmButtonColor: '#7cd1f9',
						});
					}
				});
			}

		});
});
