var site_url = $('#site_url').val();
var id;

function sweetAlert2(type, text) {
	Swal.fire({
		type: type,
		title: 'แจ้งเตือน',
		text: text,
		confirmButtonText: 'ตกลง',
		confirmButtonColor: '#7cd1f9',
	});
}

$(document).ready(function() {
	$('.dropify').dropify({
		tpl: {
			wrap: '<div class="dropify-wrapper"></div>',
			loader: '<div class="dropify-loader"></div>',
			message: '<div class="dropify-message"><span class="file-icon" /><br /> {{ default }}</div>',
			preview: '<div class="dropify-preview"><span class="dropify-render"></span><div class="dropify-infos"><div class="dropify-infos-inner"><p class="dropify-infos-message">{{ replace }}</p></div></div></div>',
			filename: '<p class="dropify-filename"><span class="file-icon"></span> <span class="dropify-filename-inner"></span></p>',
			clearButton: '<button type="button" class="dropify-clear">{{ remove }}</button>',
			errorLine: '<p class="dropify-error">ตรวจสอบชนิดไฟล์ให้ถูกต้อง</p>',
			errorsContainer: '<div class="dropify-errors-container"><ul></ul></div>'
		}
	});
	$.fn.dataTable.ext.errMode = 'throw';
	var table = $('#table').DataTable({
		"language": {
			"decimal": "",
			"emptyTable": "ไม่พบข้อมูล",
			"info": "แสดง _START_ ถึง _END_ จาก _TOTAL_ รายการ",
			"infoEmpty": "แสดง 0 ถึง 0 จาก 0 รายการ",
			"infoFiltered": "(ค้นหา จากทั้งหมด _MAX_ รายการ )",
			"infoPostFix": "",
			"thousands": ",",
			"lengthMenu": "แสดง _MENU_ รายการ",
			"loadingRecords": "Loading...",
			"processing": "Processing...",
			"search": "ค้นหา:",
			"zeroRecords": "ไม่พบข้อมูลที่ค้นหา",
			"paginate": {
				"first": "หน้าแรก",
				"last": "หน้าสุดท้าย",
				"next": "ถัดไป",
				"previous": "ย้อนกลับ"
			},
			"aria": {
				"sortAscending": ": activate to sort column ascending",
				"sortDescending": ": activate to sort column descending"
			}

		},
		"ordering": false,
		"pageLength": 50,
		ajax: {
			url: site_url + 'tournament/get_tournament',
			// data: {
			// 	domain: domain
			// },
			dataSrc: 'tournament',
		},
		columns: [{
				className: 'text-center',
				"render": function(data, type, full, meta) {
					if (full.tournament_image_file != "") {
						return '<a class="popup-image lozad" href="javascript:void(0)" data-src="' + full.tournament_image + '" data-url="' + full.tournament_image + '"><img  src="' + full.tournament_image + '" width="80px;"/></a>';
					} else {
						return "";
					}
				}
			},
			{
				className: 'text-center',
				data: 'tournament_name'
			},
			{
				// sortable: false,
				className: 'text-center',
				"render": function(data, type, full, meta) {

					// var name = full.ads_owner;
					// return'';
					return '<button  class="btn btn-warning btn_update text-white m-r-5"  data-file="' + full.tournament_image_file + '" data-image="' + full.tournament_image + '" data-name="' + full.tournament_name + '" data-id="' + full.id + '" title="แก้ไข"><i class="ti-pencil"></i> แก้ไข</button>' +
						'<button class="btn btn-danger btn_delete" title="ลบ" data-name="' + full.tournament_name + '" data-id="' + full.id + '"> <i class="ti-trash text-white"></i> ลบ</button>';
				}

			}
		]

	});
	setInterval(function() {
		table.ajax.reload(null, false);
	}, 5000);
});
$(document).on('click', '#btn_add', function() {
	var drEvent = $('.dropify').dropify();
	drEvent = drEvent.data('dropify');
	drEvent.resetPreview();
	drEvent.clearElement();
	$('#tournament_name').val('');
	$('#modal_save').modal('toggle');
});

$(document).on('submit', '#form_save', function(e) {
	var tournament_name = $('#tournament_name').val();
	if (tournament_name.trim().length == 0) {
		sweetAlert2('warning', 'กรุณากรอกข้อมูล ชื่อลีค / ทัวร์นาเม้นท์');
		return false;
	}
	/** var tournament_image = $('#tournament_image').val();
	if (tournament_image == "") {
		sweetAlert2('warning', 'กรุณาเลือกไฟล์ รูปภาพ Tournament');
		return false;
	}*/
	Swal.fire({
			title: "แจ้งเตือน",
			text: "กรุณารอสักครู่..",
			showConfirmButton: false,
			allowOutsideClick: false,
			allowEscapeKey: false,
		}),
		Swal.showLoading();
	$.ajax({
		url: site_url + "tournament/tournament_save",
		method: "POST",
		data: new FormData(this),
		contentType: false,
		cache: false,
		processData: false,
		dataType: 'json',
		success: function(response) {
			$('#modal_save').modal('toggle');
			refreshTable();
			const Toast = Swal.mixin({
				toast: true,
				position: 'top-end',
				showConfirmButton: false,
				timer: 2500
			});
			Toast.fire({
				type: 'success',
				title: 'เพิ่มข้อมูลเรียบร้อยแล้ว'
			});
		},
		error: function() {
			sweetAlert2('warning', 'การเชื่อมต่อขัดข้อง');
		}
	});
	e.preventDefault();
});

$(document).on('click', '.btn_update', function() {
	id = $(this).data('id');
	var name = $(this).data('name');
	$('#tournament_name_update').val(name);

	var image = $(this).data('image');
	var file = $(this).data('file');


	var drEvent = $('#tournament_image_update').dropify({
		defaultFile: image
	});
	drEvent = drEvent.data('dropify');
	drEvent.resetPreview();
	drEvent.clearElement();
	drEvent.settings.defaultFile = image;
	drEvent.destroy();
	drEvent.init();
	$('#tournament_image_update').attr('title', image);


	$('#modal_update').modal('toggle');
});

$(document).on('submit', '#form_update', function(e) {
	var tournament_name = $('#tournament_name_update').val();
	if (tournament_name.trim().length == 0) {
		sweetAlert2('warning', 'กรุณากรอกข้อมูล ชื่อลีค / ทัวร์นาเม้นท์');
		return false;
	}
	Swal.fire({
			title: "แจ้งเตือน",
			text: "กรุณารอสักครู่..",
			showConfirmButton: false,
			allowOutsideClick: false,
			allowEscapeKey: false,
		}),
		Swal.showLoading();
	var formData = new FormData(this);
	formData.append("id", id);
	$.ajax({
		url: site_url + "tournament/tournament_update",
		method: "POST",
		data: formData,
		contentType: false,
		cache: false,
		processData: false,
		dataType: 'json',
		success: function(response) {
			$('#modal_update').modal('toggle');
			refreshTable();
			const Toast = Swal.mixin({
				toast: true,
				position: 'top-end',
				showConfirmButton: false,
				timer: 2500
			});
			Toast.fire({
				type: 'success',
				title: 'แก้ไขข้อมูลเรียบร้อยแล้ว'
			});
		},
		error: function() {
			sweetAlert2('warning', 'การเชื่อมต่อขัดข้อง');
		}
	});
	e.preventDefault();
});

$(document).on('click', '.btn_delete', function() {
	id = $(this).data('id');
	name = $(this).data('name');

	Swal.fire({
			type: 'warning',
			title: 'แจ้งเตือน',
			text: 'ยืนยันการลบข้อมูล Tournament ' + name,
			confirmButtonText: 'ตกลง',
			confirmButtonColor: '#7cd1f9',
			showCancelButton: true,
			cancelButtonText: 'ยกเลิก',
			reverseButtons: true,
		})
		.then((result) => {
			if (result.value) {
				Swal.fire({
						title: "แจ้งเตือน",
						text: "กรุณารอสักครู่..",
						showConfirmButton: false,
						allowOutsideClick: false,
						allowEscapeKey: false,
					}),
					Swal.showLoading();
				$.ajax({
					url: site_url + "tournament/tournament_delete",
					method: "POST",
					data: {
						id: id
					},
					dataType: 'json',
					success: function(response) {
						refreshTable();
						const Toast = Swal.mixin({
							toast: true,
							position: 'top-end',
							showConfirmButton: false,
							timer: 2500
						});
						Toast.fire({
							type: 'success',
							title: 'ลบข้อมูลเรียบร้อยแล้ว'
						});
					},
					error: function() {
						sweetAlert2('warning', 'การเชื่อมต่อขัดข้อง');
					}
				});
			}

		});
});

function refreshTable() {
	var table = $('#table').DataTable();
	table.ajax.reload();
}
$(document).on('click', '.popup-image', function() {
	var image_url = $(this).data('url');
	$.magnificPopup.open({
		items: {
			src: image_url
		},
		type: 'image'
	});
});
