var site_url = $('#site_url').val();

$(document).ready(function() {
	$.fn.dataTable.ext.errMode = 'throw';
	var table = $('#table').DataTable({
		"language": {
			"decimal": "",
			"emptyTable": "ไม่พบข้อมูล",
			"info": "แสดง _START_ ถึง _END_ จาก _TOTAL_ รายการ",
			"infoEmpty": "แสดง 0 ถึง 0 จาก 0 รายการ",
			"infoFiltered": "(ค้นหา จากทั้งหมด _MAX_ รายการ )",
			"infoPostFix": "",
			"thousands": ",",
			"lengthMenu": "แสดง _MENU_ รายการ",
			"loadingRecords": "Loading...",
			"processing": "Processing...",
			"search": "ค้นหา:",
			"zeroRecords": "ไม่พบข้อมูลที่ค้นหา",
			"paginate": {
				"first": "หน้าแรก",
				"last": "หน้าสุดท้าย",
				"next": "ถัดไป",
				"previous": "ย้อนกลับ"
			},
			"aria": {
				"sortAscending": ": activate to sort column ascending",
				"sortDescending": ": activate to sort column descending"
			}

		},
		"ordering": false,
		"pageLength": 50,
		ajax: {
			url: site_url + 'fixture/get_fixture',
			// data: {
			// 	domain: domain
			// },
			dataSrc: 'fixture',
		},
		columns: [{
				className: 'text-center',
				data: 'home_name'
			},
			{
				className: 'text-center',
				data: 'away_name'
			},
			{
				className: 'text-center',
				data: 'tournament'
			},
			{
				className: 'text-center',
				data: 'fixture_date'
			},
			{
				className: 'text-center',
				data: 'fixture_time'
			},
			{
				// sortable: false,
				className: 'text-center',
				"render": function(data, type, full, meta) {
					var update = site_url + 'fixture/form_update/' + full.id;
					var name = full.home_name + ' vs ' + full.away_name

					// var name = full.ads_owner;
					// return'';
					// <a href=""></a>
					return '<a href="' + update + '" class="btn btn-warning btn_update text-white m-r-5"  data-id="' + full.id + '"  title="แก้ไข"><i class="ti-pencil"></i> แก้ไข</a>' +
						'<button class="btn btn-danger btn_delete"  data-id="' + full.id + '"  data-name="' + name + '"  title="ลบ"> <i class="ti-trash text-white"></i> ลบ</button>';
				}

			}
		]

	});
	setInterval(function() {
		table.ajax.reload(null, false);
	}, 5000);
});
$(document).on('click', '.btn_delete', function() {
	id = $(this).data('id');
	name = $(this).data('name');

	Swal.fire({
			type: 'warning',
			title: 'แจ้งเตือน',
			text: 'ยืนยันการลบข้อมูล ' + name,
			confirmButtonText: 'ตกลง',
			confirmButtonColor: '#7cd1f9',
			showCancelButton: true,
			cancelButtonText: 'ยกเลิก',
			reverseButtons: true,
		})
		.then((result) => {
			if (result.value) {
				Swal.fire({
						title: "แจ้งเตือน",
						text: "กรุณารอสักครู่..",
						showConfirmButton: false,
						allowOutsideClick: false,
						allowEscapeKey: false,
					}),
					Swal.showLoading();
				$.ajax({
					url: site_url + "fixture/fixture_delete",
					method: "POST",
					data: {
						id: id
					},
					dataType: 'json',
					success: function(response) {
						refreshTable();
						const Toast = Swal.mixin({
							toast: true,
							position: 'top-end',
							showConfirmButton: false,
							timer: 2500
						});
						Toast.fire({
							type: 'success',
							title: 'ลบข้อมูลเรียบร้อยแล้ว'
						});
					},
					error: function() {
						sweetAlert2('warning', 'การเชื่อมต่อขัดข้อง');
					}
				});
			}

		});
});
function refreshTable() {
	var table = $('#table').DataTable();
	table.ajax.reload();
}
