var site_url = $('#site_url').val();
var id;

function sweetAlert2(type, text) {
	Swal.fire({
		type: type,
		title: 'แจ้งเตือน',
		text: text,
		confirmButtonText: 'ตกลง',
		confirmButtonColor: '#7cd1f9',
	});
}

$(document).ready(function() {
	$('.dropify').dropify({
		tpl: {
			wrap: '<div class="dropify-wrapper"></div>',
			loader: '<div class="dropify-loader"></div>',
			message: '<div class="dropify-message"><span class="file-icon" /><br /> {{ default }}</div>',
			preview: '<div class="dropify-preview"><span class="dropify-render"></span><div class="dropify-infos"><div class="dropify-infos-inner"><p class="dropify-infos-message">{{ replace }}</p></div></div></div>',
			filename: '<p class="dropify-filename"><span class="file-icon"></span> <span class="dropify-filename-inner"></span></p>',
			clearButton: '<button type="button" class="dropify-clear">{{ remove }}</button>',
			errorLine: '<p class="dropify-error">ตรวจสอบชนิดไฟล์ให้ถูกต้อง</p>',
			errorsContainer: '<div class="dropify-errors-container"><ul></ul></div>'
		}
	});
	var table = $('#table').DataTable({
		"language": {
			"decimal": "",
			"emptyTable": "ไม่พบข้อมูล",
			"info": "แสดง _START_ ถึง _END_ จาก _TOTAL_ รายการ",
			"infoEmpty": "แสดง 0 ถึง 0 จาก 0 รายการ",
			"infoFiltered": "(ค้นหา จากทั้งหมด _MAX_ รายการ )",
			"infoPostFix": "",
			"thousands": ",",
			"lengthMenu": "แสดง _MENU_ รายการ",
			"loadingRecords": "Loading...",
			"processing": "Processing...",
			"search": "ค้นหา:",
			"zeroRecords": "ไม่พบข้อมูลที่ค้นหา",
			"paginate": {
				"first": "หน้าแรก",
				"last": "หน้าสุดท้าย",
				"next": "ถัดไป",
				"previous": "ย้อนกลับ"
			},
			"aria": {
				"sortAscending": ": activate to sort column ascending",
				"sortDescending": ": activate to sort column descending"
			}

		},
		"ordering": false,
		"pageLength": 50,
		ajax: {
			url: site_url + 'channel/get_channel',
			// data: {
			// 	domain: domain
			// },
			dataSrc: 'channel',
		},
		columns: [{
				className: 'text-center',
				"render": function(data, type, full, meta) {
					return '<a class="popup-image" href="javascript:void(0)" data-url="' + full.channel_image + '"><img  src="' + full.channel_image + '" width="80px;"/></a>';
				}
			},
			{
				className: 'text-center',
				data: 'channel_name'
			},
			{
				// sortable: false,
				className: 'text-center',
				"render": function(data, type, full, meta) {

					// var name = full.ads_owner;
					// return'';
					return '<button  class="btn btn-warning btn_update text-white m-r-5" data-image="' + full.channel_image + '" data-name="' + full.channel_name + '" data-id="' + full.id + '"  title="แก้ไข"><i class="ti-pencil"></i> แก้ไข</button>' +
						'<button class="btn btn-danger btn_delete"  data-id="' + full.id + '" data-name="' + full.channel_name + '" title="ลบ"> <i class="ti-trash text-white"></i> ลบ</button>';
				}

			}
		]

	});
	setInterval(function() {
		table.ajax.reload(null, false);
	}, 5000);
});
$(document).on('click', '#btn_add', function() {
	var drEvent = $('.dropify').dropify();
	drEvent = drEvent.data('dropify');
	drEvent.resetPreview();
	drEvent.clearElement();
	$('#channel_name').val('');
	$('#url_ufa').val('');
	$('#url_rca').val('');
	$('#url_biobet').val('');
	$('#modal_save').modal('toggle');
});

$(document).on('submit', '#form_save', function(e) {
	var channel_name = $('#channel_name').val();
	if (channel_name.trim().length == 0) {
		sweetAlert2('warning', 'กรุณากรอกข้อมูลชื่อ Channel');
		return false;
	}
	var image = $('#channel_image').val();
	if (image == "") {
		sweetAlert2('warning', 'กรุณาเลือกไฟล์ รูปภาพ Channel');
		return false;
	}
	var url_ufa = $('#url_ufa').val();
	if (url_ufa.trim().length == 0) {
		sweetAlert2('warning', 'กรุณาใส่link ufa');
		return false;
	}
	var url_rca = $('#url_rca').val();
	if (url_rca.trim().length == 0) {
		sweetAlert2('warning', 'กรุณาใส่link rca');
		return false;
	}
	var url_biobet = $('#url_biobet').val();
	if (url_biobet.trim().length == 0) {
		sweetAlert2('warning', 'กรุณาใส่link biobet');
		return false;
	}

	Swal.fire({
			title: "แจ้งเตือน",
			text: "กรุณารอสักครู่..",
			showConfirmButton: false,
			allowOutsideClick: false,
			allowEscapeKey: false,
		}),
		Swal.showLoading();
	$.ajax({
		url: site_url + "channel/channel_save",
		method: "POST",
		data: new FormData(this),
		contentType: false,
		cache: false,
		processData: false,
		dataType: 'json',
		success: function(response) {
			$('#modal_save').modal('toggle');
			refreshTable();
			const Toast = Swal.mixin({
				toast: true,
				position: 'top-end',
				showConfirmButton: false,
				timer: 2500
			});
			Toast.fire({
				type: 'success',
				title: 'เพิ่มข้อมูลเรียบร้อยแล้ว'
			});
		},
		error: function() {
			sweetAlert2('warning', 'การเชื่อมต่อขัดข้อง');
		}
	});
	e.preventDefault();
});

$(document).on('click', '.btn_update', function() {
	id = $(this).data('id');
	var name = $(this).data('name');
	$('#channel_name_update').val(name);

	var ufa = $(this).data('name');
	$('#url_ufa_update').val(name);

	var rca = $(this).data('name');
	$('#url_rca_update').val(name);

	var biobet = $(this).data('name');
	$('#url_biobel_update').val(name);

	var image = $(this).data('image');

	var drEvent = $('#channel_image_update').dropify({
		defaultFile: image
	});
	drEvent = drEvent.data('dropify');
	drEvent.resetPreview();
	drEvent.clearElement();
	drEvent.settings.defaultFile = image;
	drEvent.destroy();
	drEvent.init();
	$('#channel_image_update').attr('title', image);
	$('#channel_id').val(id);
	$('#modal_update').modal('toggle');
});

$(document).on('submit', '#form_update', function(e) {
	var channel_name = $('#channel_name_update').val();
	if (channel_name.trim().length == 0) {
		sweetAlert2('warning', 'กรุณากรอกข้อมูล ชื่อลีค / ทัวร์นาเม้นท์');
		return false;
	}
	var channel_name = $('#url_ufa_update').val();
	if (channel_name.trim().length == 0) {
		sweetAlert2('warning', 'กรุณากรอกข้อมูล ชื่อลีค / ทัวร์นาเม้นท์');
		return false;
	}
	var channel_name = $('#url_rca_update').val();
	if (channel_name.trim().length == 0) {
		sweetAlert2('warning', 'กรุณากรอกข้อมูล ชื่อลีค / ทัวร์นาเม้นท์');
		return false;
	}
	var channel_name = $('#url_biobet_update').val();
	if (channel_name.trim().length == 0) {
		sweetAlert2('warning', 'กรุณากรอกข้อมูล ชื่อลีค / ทัวร์นาเม้นท์');
		return false;
	}
	Swal.fire({
			title: "แจ้งเตือน",
			text: "กรุณารอสักครู่..",
			showConfirmButton: false,
			allowOutsideClick: false,
			allowEscapeKey: false,
		}),
		Swal.showLoading();
	$.ajax({
		url: site_url + "channel/channel_update",
		method: "POST",
		method: "POST",
		data: new FormData(this),
		contentType: false,
		cache: false,
		processData: false,
		dataType: 'json',
		success: function(response) {
			$('#modal_update').modal('toggle');
			refreshTable();
			const Toast = Swal.mixin({
				toast: true,
				position: 'top-end',
				showConfirmButton: false,
				timer: 2500
			});
			Toast.fire({
				type: 'success',
				title: 'แก้ไขข้อมูลเรียบร้อยแล้ว'
			});
		},
		error: function() {
			sweetAlert2('warning', 'การเชื่อมต่อขัดข้อง');
		}
	});
	e.preventDefault();
});

$(document).on('click', '.btn_delete', function() {
	id = $(this).data('id');
	name = $(this).data('name');

	Swal.fire({
			type: 'warning',
			title: 'แจ้งเตือน',
			text: 'ยืนยันการลบข้อมูล Channel ' + name,
			confirmButtonText: 'ตกลง',
			confirmButtonColor: '#7cd1f9',
			showCancelButton: true,
			cancelButtonText: 'ยกเลิก',
			reverseButtons: true,
		})
		.then((result) => {
			if (result.value) {
				 	Swal.fire({
					title: "แจ้งเตือน",
					text: "กรุณารอสักครู่..",
					showConfirmButton: false,
					allowOutsideClick: false,
					allowEscapeKey: false,
				}),
				Swal.showLoading();
				$.ajax({
					url: site_url + "channel/channel_delete",
					method: "POST",
					data: {
						id: id
					},
					dataType: 'json',
					success: function(response) {
						refreshTable();
						const Toast = Swal.mixin({
							toast: true,
							position: 'top-end',
							showConfirmButton: false,
							timer: 2500
						});
						Toast.fire({
							type: 'success',
							title: 'ลบข้อมูลเรียบร้อยแล้ว'
						});
					},
					error: function() {
						sweetAlert2('warning', 'การเชื่อมต่อขัดข้อง');
					}
				});
			}

		});
});

function refreshTable() {
	var table = $('#table').DataTable();
	table.ajax.reload();
}
$(document).on('click', '.popup-image', function() {
	var image_url = $(this).data('url');
	$.magnificPopup.open({
		items: {
			src: image_url
		},
		type: 'image'
	});
});
