<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Fixture_model extends CI_Model
{
    public function fixture_save($input)
    {
        $this->db->insert('fixture', $input);
        $id = $this->db->insert_id();
        return $id;
    }
    public function fixture_update($input)
    {
        $this->db->where('fixture_id', $input['fixture_id']);
        $this->db->update('fixture', $input);
    }
    public function fixture_id($id)
    {
        $this->db->where('fixture_id', $id);
        $query = $this->db->get('fixture');
        return $query->row_array();
    }
    public function fixture_channel_fixture($id)
    {
        $this->db->where('fixture_channel_fixture', $id);
        $this->db->join('channel', 'channel.channel_id = fixture_channel.fixture_channel');
        $query = $this->db->get('fixture_channel');
        return $query->result_array();
    }
    public function fixture()
    {
        $this->db->select(
                            'fixture_id as id,
                            fixture_team_home,
                            fixture_team_away,
                            fixture_tournament,
                            fixture_date,
                            fixture_time,

                            '
        );
        // $this->db->join('team', 'team.team_id = fixture.fixture_team_home');
        $this->db->order_by('fixture_id', 'DESC');
        $query = $this->db->get('fixture');
        return $query->result_array();
    }

    public function fixture_delete($id)
    {
        $this->db->where('fixture_id', $id);
        $this->db->delete('fixture');
    }
    public function fixture_channel_save($input)
    {
        $this->db->insert('fixture_channel', $input);
    }
    public function fixture_channel_update($input)
    {
        $this->db->where('fixture_channel_id', $input['fixture_channel_id']);
        $this->db->update('fixture_channel', $input);
    }
    public function fixture_channel_delete_fixture($id)
    {
        $this->db->where('fixture_channel_fixture', $id);
        $this->db->delete('fixture_channel');
    }
    // public function fixture_api()
    // {
    //     date_default_timezone_set('Asia/Bangkok');
    //     $this->db->select(
    //                         'fixture_id as id,
    //                         fixture_team_home,
    //                         fixture_team_away,
    //                         fixture_tournament,
    //                         fixture_date,
    //                         fixture_time,
    //
    //                         '
    //     );
    //     $this->db->where('fixture_date', date('Y-m-d'));
    //     $this->db->order_by('fixture_time', 'ASC');
    //     // $this->db->order_by('fixture_id', 'DESC');
    //     $query = $this->db->get('fixture');
    //     return $query->result_array();
    // }
    public function fixture_api()
    {

        $minus_two_hrs = date("Y-m-d H:i:s", strtotime("-2 hours"));
        $time = new DateTime($minus_two_hrs);
        $date = date_create(date('Y-m-d'));
        date_add($date, date_interval_create_from_date_string('1 days'));
        $next_date = date_format($date, 'Y-m-d');
        $old_date = date_create(date('Y-m-d'));
        $old_date = date_add($old_date, date_interval_create_from_date_string('-1 days'));
        $old_date = date_format($old_date, 'Y-m-d');
        if (date('H:i')>='02:00'&&date('H:i')<='23:00') {//ตี 2 ถึง 5 ทุ่ม

          $query = $this->db->select(
                                      'fixture_id as id,
                                      fixture_team_home,
                                      fixture_team_away,
                                      fixture_tournament,
                                      fixture_date,
                                      fixture_time,

                                      '
                                      )->from('fixture')
                                      ->group_start()
                                      ->order_by('fixture_date', 'ASC')
                                      ->order_by('fixture_time', 'ASC')
                                      ->where('fixture_date', date('Y-m-d'))
                                      ->where('fixture_time >=', $time->format('H:i'))

                                      ->or_group_start()
                                      ->order_by('fixture_date', 'ASC')
                                      ->order_by('fixture_time', 'ASC')
                                      ->where('fixture_date', $next_date)
                                      ->where('fixture_time <=', '09:00:00')


                                      ->group_end()

                                      ->group_end()

                                      ->get();
          return $query->result_array();
        }else {
          $query = $this->db->select(
                                      'fixture_id as id,
                                      fixture_team_home,
                                      fixture_team_away,
                                      fixture_tournament,
                                      fixture_date,
                                      fixture_time,

                                      '
                                      )->from('fixture')
                                      ->group_start()
                                      ->order_by('fixture_date', 'ASC')
                                      ->order_by('fixture_time', 'ASC')
                                      ->where('fixture_date', date('Y-m-d'))
                                      // ->where('fixture_time >=', $time->format('H:i'))
                                      //
                                      ->or_group_start()
                                      ->order_by('fixture_date', 'ASC')
                                      ->order_by('fixture_time', 'ASC')
                                      ->where('fixture_date', $old_date)
                                      ->where('fixture_time >=', '23:00:00')
                                      ->group_end()


                                      ->or_group_start()
                                      ->order_by('fixture_date', 'ASC')
                                      ->order_by('fixture_time', 'ASC')
                                      ->where('fixture_date', $next_date)
                                      ->where('fixture_time <=', '09:00:00')


                                      ->group_end()

                                      ->group_end()
                                      ->get();
          return $query->result_array();

        }
    }
    public function fixture_api2($tournament_id)
    {

        $minus_two_hrs = date("Y-m-d H:i:s", strtotime("-2 hours"));
        $time = new DateTime($minus_two_hrs);
        $date = date_create(date('Y-m-d'));
        date_add($date, date_interval_create_from_date_string('1 days'));
        $next_date = date_format($date, 'Y-m-d');

        $old_date = date_create(date('Y-m-d'));
        $old_date = date_add($old_date, date_interval_create_from_date_string('-1 days'));
        $old_date = date_format($old_date, 'Y-m-d');

        if (date('H:i')>='02:00'&&date('H:i')<'23:00') {
          $query = $this->db->select(
                                      'fixture_id as id,
                                      fixture_team_home,
                                      fixture_team_away,
                                      fixture_tournament,
                                      fixture_date,
                                      fixture_time,
                                      tournament_name,

                                      '
                                      )->from('fixture')
                                      ->group_start()
                                      ->order_by('fixture_date', 'ASC')
                                      ->order_by('fixture_time', 'ASC')
                                      ->where('fixture_date', date('Y-m-d'))
                                      ->where('fixture_time >=', $time->format('H:i'))

                                      ->or_group_start()
                                      ->order_by('fixture_date', 'ASC')
                                      ->order_by('fixture_time', 'ASC')
                                      ->where('fixture_date', $next_date)
                                      ->where('fixture_time <=', '09:00:00')


                                      ->group_end()

                                      ->group_end()
                                      ->join('tournament', 'tournament.tournament_id = fixture.fixture_tournament')
                                      ->where('fixture_tournament', $tournament_id)
                                      ->get();
          return $query->result_array();
        }else {
          $query = $this->db->select(
                                      'fixture_id as id,
                                      fixture_team_home,
                                      fixture_team_away,
                                      fixture_tournament,
                                      fixture_date,
                                      fixture_time,
                                      tournament_name,

                                      '
                                      )->from('fixture')
                                      ->group_start()
                                      ->order_by('fixture_date', 'ASC')
                                      ->order_by('fixture_time', 'ASC')
                                      ->where('fixture_date', date('Y-m-d'))

                                      ->or_group_start()
                                      ->order_by('fixture_date', 'ASC')
                                      ->order_by('fixture_time', 'ASC')
                                      ->where('fixture_date', $old_date)
                                      ->where('fixture_time >=', '23:00:00')
                                      ->group_end()


                                      ->or_group_start()
                                      ->order_by('fixture_date', 'ASC')
                                      ->order_by('fixture_time', 'ASC')
                                      ->where('fixture_date', $next_date)
                                      ->where('fixture_time <=', '09:00:00')
                                      ->group_end()

                                      ->group_end()
                                      ->join('tournament', 'tournament.tournament_id = fixture.fixture_tournament')
                                      ->where('fixture_tournament', $tournament_id)
                                      ->get();
          return $query->result_array();
        }

    }
}
