<link rel="stylesheet" href="<?php echo base_url('node_modules/select2/dist/css/select2.min.css')?>">
<link rel="stylesheet" href="<?php echo base_url('node_modules/select2-theme/dist/select2-bootstrap4.css')?>">

<div class="container-fluid">
  <div class="row page-titles">
    <div class="col-md-5 align-self-center">
      <h3 class="text-themecolor">เพิ่มโรงพยาบาล/คลินิก</h3>
    </div>
    <div class="col-md-7 align-self-center">
      <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="<?php echo site_url('Home'); ?>">หน้าหลัก</a></li>
        <li class="breadcrumb-item"><a href="<?php echo site_url('Hospital'); ?>">จัดการโรงพยาบาล/คลินิก</a></li>
        <li class="breadcrumb-item active">เพิ่มโรงพยาบาล/คลินิก</li>
      </ol>
    </div>
  </div>
  <div class="row">
    <div class="col-12">
      <div class="card">
        <div class="card-body">
          <?php echo form_open_multipart('Hospital/hospital_save') ?>
            <h3 class="card-title">ข้อมูลโรงพยาบาล/คลินิก</h3>
            <hr>
            <div class="row p-t-20">
              <div class="col-md-12">
                <div class="form-group">
                  <label class="control-label">ชื่อโรงพยาบาล/คลินิก</label>
                  <input type="text" id="hospital_name" name="hospital_name" class="form-control" placeholder="ข้อมูลชื่อโรงพยาบาล/คลินิก">
                </div>
              </div>

            </div>
            <div class="row">
              <div class="col-md-6">
                <div class="form-group">
                  <label class="control-label">ที่อยู่</label>
                  <textarea id="hospital_address" name="hospital_address" class="form-control" rows="4" placeholder="ข้อมูลที่อยู่"></textarea>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label class="control-label">ตรอก/ซอย</label>
                  <textarea id="hospital_alley" name="hospital_alley" class="form-control" rows="4" placeholder="ข้อมูลตรอก/ซอย"></textarea>
                </div>
              </div>
            </div>
            <div class="row">
              <div class="col-md-4">
                <div class="form-group">
                  <label class="control-label">จังหวัด</label>
                  <select class="form-control" id="hospital_province" name="hospital_province">
                    <option value="">
                      เลือกจังหวัด
                    </option>
                    <?php foreach ($province as $key => $value): ?>
                      <option value="<?php echo $value['province_id'] ?>">
                        <?php echo $value['province_name'] ?>
                      </option>
                      <?php endforeach; ?>
                  </select>
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                  <label class="control-label">เขต/อำเภอ</label>
                  <select class="form-control" id="hospital_amphure" name="hospital_amphure">
                    <option value="">
                      เลือกเขต/อำเภอ
                    </option>
                  </select>
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                  <label class="control-label">แขวง/ตำบล</label>
                  <select class="form-control" id="hospital_district" name="hospital_district">
                    <option value="">
                      เลือกแขวง/ตำบล
                    </option>
                  </select>
                </div>
              </div>
            </div>
            <div class="row">
              <div class="col-md-4">
                <div class="form-group">
                  <label class="control-label">รหัสไปรษณีย์</label>
                  <input type="text" id="hospital_zip" name="hospital_zip" class="form-control" placeholder="ข้อมูลรหัสไปรษณีย์">
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                  <label class="control-label">โทร</label>
                  <input type="text" id="hospital_phone" name="hospital_phone" class="form-control" placeholder="ข้อมูลเบอร์โทร">
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                  <label class="control-label">อีเมล</label>
                  <input type="text" id="hospital_email" name="hospital_email" class="form-control" placeholder="ข้อมูลอีเมล">
                </div>
              </div>
            </div>

            <hr />
            <div class="row">
              <div class="col-md-12">
                <div class="text-right m-b-10">
                  <a href="<?php echo site_url('Hospital') ?>" class="btn btn-danger" data-dismiss="modal"><i class="icon-close text-white m-r-5"></i> ยกเลิก</a>
                  <button type="submit" id="btn_submit" class="btn btn-success"><i class="fa fa-save m-r-5"></i> บันทึก</button>
                </div>
              </div>
            </div>
            <?php echo form_close() ?>
        </div>
      </div>
    </div>
    <script>
      <?php
    echo "var amphure = ". json_encode($amphure) . ";";
    echo "var district = ". json_encode($district) . ";";
    echo "var zip_code = ". json_encode($zip_code) . ";";
    ?>
    </script>
    <script src="<?php echo base_url('node_modules/sweetalert2/dist/sweetalert2.all.min.js') ?>"></script>
    <script src="<?php echo base_url('node_modules/select2/dist/js/select2.full.min.js') ?>"></script>
    <script src="<?php echo base_url('assets/js/view/hospital/hospital_save.js') ?>"></script>
