<div class="table-responsive">
  <table class="table table-bordered" id="table">
    <thead>
      <tr>
        <th class="text-right" width="10%">#</th>
        <th class="text-center">รหัส</th>
        <th class="text-center">รายการ</th>
        <th class="text-center">ราคา</th>
        <th class="text-nowrap text-center" width="30%">จัดการข้อมูล</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($biopsy as $key => $value): ?>
        <tr>
          <td class="text-right">
            <?php echo $key+1; ?>
          </td>
          <td class="text-right">
            <?php echo $value['biopsy_code']; ?>
          </td>
          <td >
            <!-- <?php echo ellipsize($value['biopsy_name'],50); ?> -->
            <?php echo $value['biopsy_name']; ?>
          </td>
          <td class="text-right">
            <?php echo number_format($value['biopsy_cost']); ?>
          </td>
          <td class="text-nowrap text-center">
            <button  class="btn btn-warning btn_update" data-data='<?php echo json_encode($value); ?>' title="แก้ไข"> <i class="icon-pencil text-white m-r-5"></i> แก้ไข</button>
            <button class="btn btn-danger btn_delete" data-name='<?php echo ellipsize($value['biopsy_name'],30); ?>'  data-data='<?php echo json_encode($value); ?>' title="ลบ"> <i class="icon-close text-white m-r-5"></i> ลบ</button>
          </td>
        </tr>
        <?php endforeach; ?>
    </tbody>
  </table>
</div>
<script>
  $(document).ready(function() {
    $('#table').DataTable({
      "language": {
        "decimal": "",
        "emptyTable": "ไม่พบข้อมูล",
        "info": "แสดง _START_ ถึง _END_ จาก _TOTAL_ รายการ",
        "infoEmpty": "แสดง 0 ถึง 0 จาก 0 รายการ",
        "infoFiltered": "(ค้นหา จากทั้งหมด _MAX_ รายการ )",
        "infoPostFix": "",
        "thousands": ",",
        "lengthMenu": "แสดง _MENU_ รายการ",
        "loadingRecords": "Loading...",
        "processing": "Processing...",
        "search": "ค้นหา:",
        "zeroRecords": "ไม่พบข้อมูลที่ค้นหา",
        "paginate": {
          "first": "หน้าแรก",
          "last": "หน้าสุดท้าย",
          "next": "ถัดไป",
          "previous": "ย้อนกลับ"
        },
        "aria": {
          "sortAscending": ": activate to sort column ascending",
          "sortDescending": ": activate to sort column descending"
        }
      },
       "pageLength": 50
    });
  });
</script>
