<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Tournament_model extends CI_Model
{
    public function tournament_save($input)
    {
        $this->db->insert('tournament', $input);
        $id = $this->db->insert_id();
        return $id;
    }
    public function tournament_id($id)
    {
        $this->db->where('tournament_id', $id);
        $query = $this->db->get('tournament');
        return $query->row_array();
    }
    public function tournament()
    {
        $this->db->select('tournament_id as id,tournament_name,tournament_image');
        $this->db->order_by('tournament_id', 'DESC');
        $query = $this->db->get('tournament');
        return $query->result_array();
    }
    public function tournament_update($input)
    {
        $this->db->where('tournament_id', $input['tournament_id']);
        $this->db->update('tournament', $input);
    }
    public function tournament_delete($id)
    {
        $this->db->where('tournament_id', $id);
        $this->db->delete('tournament');
    }
    public function tournament_order_index_api()
    {
        $this->db->select(
                          'tournament_id,
                            tournament_name,
                            tournament_index,
                            tournament_image
                          '
                        );
        $this->db->where('tournament_index !=', 0);
        $this->db->order_by('tournament_index', 'ASC');
        $query = $this->db->get('tournament');
        return $query->result_array();
    }
    public function tournament_name_asc()
    {
        $this->db->select(
                          'tournament_id,
                            tournament_name,
                            tournament_index,
                            tournament_image
                          '
                        );
        $this->db->where('tournament_index', 0);
        $this->db->order_by('tournament_name', 'ASC');
        $query = $this->db->get('tournament');
        return $query->result_array();
    }
}
