<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Tournament extends CI_Controller
{
    public function index()
    {
        $data['page'] = 'tournament/tournament';
        $this->load->view('main', $data);
        // if (!isset($_SESSION['user'])) {
        //     redirect('auth');
        // }
    }
    public function tournament_save()
    {
        $input = array(
                        'tournament_name' => $this->input->post('tournament_name'),
                      );
        $upload = $this->file_upload("tournament_image");
        if ($upload!="") {
            $input['tournament_image'] = $upload;
        }
        $id = $this->Tournament_model->tournament_save($input);
        $result = $this->Tournament_model->tournament_id($id);
        echo json_encode(
         array(
                 'status' => true,
                 'result' => $result
               )
         );
    }
    public function tournament_update()
    {
        $input = array(
                        'tournament_id' => $this->input->post('id'),
                        'tournament_name' => $this->input->post('tournament_name_update'),
                      );

        $upload = $this->file_upload("tournament_image_update");
        if ($upload!="") {
            $tournament = $this->Tournament_model->tournament_id($input['tournament_id']);
            $path = "src/images/tournament/{$tournament['tournament_image']}";
            if (file_exists($path)) {
                unlink($path);
            } else {
            }
            $input['tournament_image'] = $upload;
        }
        $this->Tournament_model->tournament_update($input);
        $result = $this->Tournament_model->tournament_id($input['tournament_id']);
        echo json_encode(
         array(
                 'status' => true,
                 'result' => $result
               )
         );
    }
    public function get_tournament()
    {
        $tournament_new  =  array();
        $tournament = $this->Tournament_model->tournament();
        foreach ($tournament as $key => $value) {
            array_push(
                $tournament_new,
                array(
                        'id' =>  $value['id'],
                        'tournament_name' =>  $value['tournament_name'],
                        'tournament_image' =>  base_url("src/images/tournament/{$value['tournament_image']}"),
                        'tournament_image_file' =>  $value['tournament_image'],

                      )
            );
        }
        echo json_encode(
                          array('tournament' => $tournament_new )
                        );
    }
    public function tournament_delete()
    {
        $this->Tournament_model->tournament_delete($this->input->post('id'));
        $tournament = $this->Tournament_model->tournament_id($this->input->post('id'));
        $path = "src/images/tournament/{$tournament['tournament_image']}";
        try {
            unlink($path);
        } catch (Exception $e) {
            echo json_encode(
             array(
                     'status' => true,
                     'result' => '',
                     'msg' => $e->getMessage()
                   )
             );
             exit();
        }

        echo json_encode(
         array(
                 'status' => true,
                 'result' => ''
               )
         );
    }
    public function file_upload($file)
    {
        $type_file = pathinfo($_FILES[$file]['name'], PATHINFO_EXTENSION);
        $random_string = random_string('alnum', 5);
        $rename = "file_".date('YmdHis').'_'.$random_string.".".$type_file;
        $config['upload_path']          = 'src/images/tournament/';
        $config['allowed_types']        = '*';
        $config['max_size']             = 60000;
        $config['max_width']            = 4000;
        $config['max_height']           = 4000;
        $config['file_name']           = $rename;

        if ($_FILES[$file]['error']==0) {
            $this->upload->initialize($config);
            $this->load->library('upload', $config);
            $this->upload->do_upload($file);
            return $rename;
        }
    }
}
