<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Team extends CI_Controller
{
    public function __construct()
    {
        date_default_timezone_set('Asia/Bangkok');
        parent::__construct();
        // if (!isset($_SESSION['user'])) {
        //     redirect('auth');
        // }
    }
    public function index()
    {
        $data['page'] = 'team/team';
        $this->load->view('main', $data);
    }
    public function team_save()
    {
        if ($this->input->method()!="post") {
            $this->my_error->show_error('Someting wrong!');
        }
        $upload = $this->file_upload('team_image');
        $input = array(
                        'team_name' => $this->input->post('team_name'),
                        'team_nickname' => $this->input->post('team_nickname'),
                      );
        if ($upload!="") {
            // $input['team_image'] = site_url().'src/images/team/'.$upload;
            $input['team_image'] = $upload;
        }
        $id = $this->Team_model->team_save($input);
        $result = $this->Team_model->team_id($id);
        echo json_encode(
         array(
                 'status' => true,
                 'result' => $result
               )
         );
    }
    public function team_update()
    {
        if ($this->input->method()!="post") {
            $this->my_error->show_error('Someting wrong!');
        }
        $input = array(
                        'team_id' => $this->input->post('team_id'),
                        'team_name' => $this->input->post('team_name_update'),
                        'team_nickname' => $this->input->post('team_nickname_update'),
                      );
        $upload = $this->file_upload('team_image_update');
        if ($upload!="") {
            $input['team_image'] = $upload;
            $team = $this->Team_model->team_id($input['team_id']);
            $path = 'src/images/team/'.$team['team_image'];
            if (file_exists($path)) {
                unlink($path);
            }
        }

        $this->Team_model->team_update($input);
        $result = $this->Team_model->team_id($input['team_id']);
        echo json_encode(
         array(
                 'status' => true,
                 'result' => $result
               )
         );
    }
    public function file_upload($file)
    {
        $type_file = pathinfo($_FILES[$file]['name'], PATHINFO_EXTENSION);
        $random_string = random_string('alnum', 5);
        $rename = "file_".date('YmdHis').'_'.$random_string.".".$type_file;
        $config['upload_path']          = 'src/images/team/';
        $config['allowed_types']        = '*';
        $config['max_size']             = 60000;
        $config['max_width']            = 4000;
        $config['max_height']           = 4000;
        $config['file_name']           = $rename;

        if ($_FILES[$file]['error']==0) {
            $this->upload->initialize($config);
            $this->load->library('upload', $config);
            $this->upload->do_upload($file);
            return $rename;
        }
    }
    public function get_team()
    {
        $team = $this->Team_model->team();
        $team_new = array();
        foreach ($team as $key => $value) {
            array_push(
                $team_new,
                        array(
                              'id' => $value['id'],
                              'team_name' => $value['team_name'],
                              'team_image' =>site_url().'src/images/team/'.$value['team_image'] ,
                              'team_nickname' =>$value['team_nickname'] ,
                              )
            );
        }
        echo json_encode(
                          array('team' => $team_new )
                        );
    }
    public function team_delete()
    {
        $team = $this->Team_model->team_id($this->input->post('id'));
        $path = 'src/images/team/'.$team['team_image'];
        if (file_exists($path)) {
            unlink($path);
        }
        $this->Team_model->team_delete($this->input->post('id'));
        echo json_encode(
         array(
                 'status' => true,
                 'result' => ''
               )
         );
    }

}
