<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Fixture extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        date_default_timezone_set("Asia/Bangkok");
        // if (!isset($_SESSION['user'])) {
        //     redirect('auth');
        // }
    }
    public function index()
    {
        $data['page'] = 'fixture/fixture';
        $this->load->view('main', $data);
    }
    public function form_save()
    {
        $teamJson = $this->curl->simple_get(site_url('team/get_team'));
        $data['team'] =  json_decode($teamJson, true);
        $channelJson = $this->curl->simple_get(site_url('channel/get_channel'));
        $data['channel'] =  json_decode($channelJson, true);
        $data['tournament'] = $this->Tournament_model->tournament();
        $data['page'] = 'fixture/form_save';
        $this->load->view('main', $data);
    }
    public function form_update()
    {
        $id = $this->uri->segment(3);
        $data['fixture'] =  $this->Fixture_model->fixture_id($id);
        $data['fixture_channel'] =  $this->Fixture_model->fixture_channel_fixture($id);
        if ($id==""||$data['fixture']=="") {
            redirect('fixture');
        }
        $teamJson = $this->curl->simple_get(site_url('team/get_team'));
        $data['team'] =  json_decode($teamJson, true);
        $channelJson = $this->curl->simple_get(site_url('channel/get_channel'));
        $data['channel'] =  json_decode($channelJson, true);
        $data['tournament'] = $this->Tournament_model->tournament();

        $data['page'] = 'fixture/form_update';
        $this->load->view('main', $data);
    }
    public function fixture_save()
    {
        if ($this->input->method()!="post") {
            $this->my_error->show_error('Someting wrong!');
        }


        // add new fixture_merge

        $fixture = array(
                          'fixture_team_home' => $this->input->post('fixture_team_home'),
                          'fixture_team_away' => $this->input->post('fixture_team_away'),
                          'fixture_tournament' => $this->input->post('fixture_tournament'),
                          'fixture_date' => $this->input->post('fixture_date'),
                          'fixture_time' => $this->input->post('fixture_time'),
                          'fixture_score' => $this->input->post('fixture_score'),
                          'k_id' => $this->input->post('fixture_merge'),
                        );



        $id = $this->Fixture_model->fixture_save($fixture);

        ///


        $fixture_merge = array(
                          'fixture_id' => $id,
                          'k_id' => $this->input->post('fixture_merge'),
                        );
        $this->Fixture_model->fixture_merge_save($fixture_merge);

        ///

        $channel = array(
                          'fixture_channel_fixture' => $id,
                          'fixture_channel' => $this->input->post('fixture_channel')[0],
                          'fixture_link' => $this->input->post('fixture_link')[0],
                        );

        $this->Fixture_model->fixture_channel_save($channel);
        redirect('fixture');
    }
    public function fixture_update()
    {
        if ($this->input->method()!="post") {
            $this->my_error->show_error('Someting wrong!');
        }
        $id = $this->uri->segment(3);
        if ($id=="") {
            redirect('fixture');
        }


        $fixture = array(
                          'fixture_id' => $id,
                          'fixture_team_home' => $this->input->post('fixture_team_home'),
                          'fixture_team_away' => $this->input->post('fixture_team_away'),
                          'fixture_tournament' => $this->input->post('fixture_tournament'),
                          'fixture_date' => $this->input->post('fixture_date'),
                          'fixture_time' => $this->input->post('fixture_time'),
                          'fixture_score' => $this->input->post('fixture_score'),
                          'k_id' => $this->input->post('fixture_merge'),
                        );

        $id = $this->Fixture_model->fixture_update($fixture);
        $channel = array(
                          'fixture_channel_id' => $this->input->post('fixture_channel_id')[0],
                          'fixture_channel' => $this->input->post('fixture_channel')[0],
                          'fixture_link' => $this->input->post('fixture_link')[0],
                        );
        $this->Fixture_model->fixture_channel_update($channel);
        redirect('fixture');
    }
    public function get_fixture()
    {
        $fixture = $this->Fixture_model->fixture();
        $fixture_new = array();
        foreach ($fixture as $key => $value) {
            $home = $this->Team_model->team_id($value['fixture_team_home']);
            $away = $this->Team_model->team_id($value['fixture_team_away']);
            $tournament = $this->Tournament_model->tournament_id($value['fixture_tournament']);
            $date_thai = $this->date_thai($value['fixture_date']);
            $time = new DateTime($value['fixture_time']);

            array_push(
                $fixture_new,
                        array(
                              'id' => $value['id'],
                              'home_name' => $home['team_name'],
                              'home_image' => site_url().'src/images/team/'.$home['team_image'],
                              'away_name' => $away['team_name'],
                              'away_image' => site_url().'src/images/team/'.$away['team_image'],
                              'fixture_date' => $date_thai,
                              'fixture_time' => $time->format('H:i'),
                              'tournament' => $tournament['tournament_name'],

                              )
            );
        }
        echo json_encode(
                          array('fixture' => $fixture_new )
                        );
    }
    public function date_thai($strDate)
    {
        $strYear = date("Y", strtotime($strDate))+543;
        $strMonth= date("n", strtotime($strDate));
        $strDay= date("j", strtotime($strDate));
        $strHour= date("H", strtotime($strDate));
        $strMinute= date("i", strtotime($strDate));
        $strSeconds= date("s", strtotime($strDate));
        // $strMonthCut = Array("","ม.ค.","ก.พ.","มี.ค.","เม.ย.","พ.ค.","มิ.ย.","ก.ค.","ส.ค.","ก.ย.","ต.ค.","พ.ย.","ธ.ค.");
        $strMonthCut = array("","มกราคม","กุมภาพันธ์","มีนาคม","เมษายน","พฤษภาคม","มิถุนายน","กรกฎาคม","สิงหาคม","กันยายน","ตุลาคม","พฤศจิกายน","ธันวาคม");

        $strMonthThai=$strMonthCut[$strMonth];
        return "$strDay $strMonthThai $strYear";
    }
    public function fixture_delete()
    {
        $this->Fixture_model->fixture_delete($this->input->post('id'));
        $this->Fixture_model->fixture_channel_delete_fixture($this->input->post('id'));

        echo json_encode(
         array(
                 'status' => true,
                 'result' => ''
               )
         );
    }
}
