<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Channel extends CI_Controller
{
    public function __construct()
    {
        date_default_timezone_set('Asia/Bangkok');
        parent::__construct();
        // if (!isset($_SESSION['user'])) {
        //     redirect('auth');
        // }
    }

    public function index()
    {
        $data['page'] = 'channel/channel';
        $this->load->view('main', $data);
    }
    public function channel_save()
    {
        $input = array(
                        'channel_name' => $this->input->post('channel_name'),
                        'url_ufa' => $this->input->post('url_ufa'),
                        'url_rca' => $this->input->post('url_rca'),
                        'url_biobet' => $this->input->post('url_biobet'),
                        'url_4k' => $value['url_4k'],
                              'goaltv' => $value['goaltv'],
                              'duball356' => $value['duball356'],
                              'all' => $value['all'],
                              'webduballfree' => $value['webduballfree'],
                              'zoneduball' => $value['zoneduball'],
                      );
        $upload = $this->file_upload('channel_image');
        if ($upload!="") {
            // $input['channel_image'] = site_url().'src/images/channel/'.$upload;
            $input['channel_image'] = $upload;
        }
        $id = $this->Channel_model->channel_save($input);
        $result = $this->Channel_model->channel_id($id);
        echo json_encode(
         array(
                 'status' => true,
                 'result' => $result
               )
         );
    }
    public function channel_update()
    {
        $input = array(
                        'channel_id' => $this->input->post('channel_id'),
                        'channel_name' => $this->input->post('channel_name_update'),
                        'url_ufa' => $this->input->post('url_ufa_update'),
                        'url_rca' => $this->input->post('url_rca_update'),
                        'url_biobet' => $this->input->post('url_biobet_update'),
                        'url_4k' => $value['url_4k'],
                              'goaltv' => $value['goaltv'],
                              'duball356' => $value['duball356'],
                              'all' => $value['all'],
                              'webduballfree' => $value['webduballfree'],
                              'zoneduball' => $value['zoneduball'],
                      );
        $upload = $this->file_upload('channel_image_update');
        if ($upload!="") {
            $input['channel_image'] = $upload;
            $channel = $this->Channel_model->channel_id($input['channel_id']);
            $path = 'src/images/channel/'.$channel['channel_image'];
            if (file_exists($path)) {
                unlink($path);
            }
        }
        $this->Channel_model->channel_update($input);
        $result = $this->Channel_model->channel_id($input['channel_id']);
        echo json_encode(
         array(
                 'status' => true,
                 'result' => $result
               )
         );
    }
    public function get_channel()
    {
        $channel = $this->Channel_model->channel();
        $channel_new = array();
        foreach ($channel as $key => $value) {
            array_push(
                $channel_new,
                        array(
                              'id' => $value['id'],
                              'channel_name' => $value['channel_name'],
                              'url_ufa' => $value['url_ufa'],
                              'url_rca' => $value['url_rca'],
                              'url_biobet' => $value['url_biobet'],
                              'url_4k' => $value['url_4k'],
                              'goaltv' => $value['goaltv'],
                              'duball356' => $value['duball356'],
                              'all' => $value['all'],
                              'webduballfree' => $value['webduballfree'],
                              'zoneduball' => $value['zoneduball'],
                              'channel_image' =>site_url().'src/images/channel/'.$value['channel_image'] ,
                              )
            );
        }
        echo json_encode(
                          array('channel' => $channel_new )
                        );
    }
    public function file_upload($file)
    {
        $type_file = pathinfo($_FILES[$file]['name'], PATHINFO_EXTENSION);
        $random_string = random_string('alnum', 5);
        $rename = "file_".date('YmdHis').'_'.$random_string.".".$type_file;
        $config['upload_path']          = 'src/images/channel/';
        $config['allowed_types']        = '*';
        $config['max_size']             = 60000;
        $config['max_width']            = 4000;
        $config['max_height']           = 4000;
        $config['file_name']           = $rename;

        //resize
        // $config['image_library'] = 'gd2';
        // $config['source_image'] = $config['upload_path'].$rename;
        // $config['create_thumb'] = TRUE;
        // $config['maintain_ratio'] = false;
        // $config['width']     = 500;
        // $config['height']   = 500;
        // $this->upload->clear();
        if ($_FILES[$file]['error']==0) {
            $this->upload->initialize($config);
            $this->load->library('upload', $config);
            $this->upload->do_upload($file);
            return $rename;
        }

        // $this->image_lib->clear();
        // $this->image_lib->initialize($config);
        // $this->load->library('image_lib', $config);
        // $this->image_lib->resize();
    }
    public function channel_delete()
    {
        $channel = $this->Channel_model->channel_id($this->input->post('id'));
        $path = 'src/images/channel/'.$channel['channel_image'];
        if (file_exists($path)) {
            unlink($path);
        }
        $this->Channel_model->channel_delete($this->input->post('id'));
        echo json_encode(
         array(
                 'status' => true,
                 'result' => ''
               )
         );
    }
}
